function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 291);

T = World_Economy_Cartel_VD.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(242) = (T(114)*(exp(y(23))*(exp(y(24))+exp(y(23)))+exp(y(23))*exp(y(23))-(exp(y(23))*exp(y(23))+exp(y(23))*exp(y(23))))-(exp(y(23))*(exp(y(24))+exp(y(23)))-exp(y(23))*exp(y(23)))*(exp(y(23))*(exp(y(24))+exp(y(23)))+exp(y(23))*(exp(y(24))+exp(y(23)))))/(T(114)*T(114));
T(243) = exp(y(24))*(exp(y(24))+exp(y(23)))+exp(y(24))*(exp(y(24))+exp(y(23)));
T(244) = (T(114)*exp(y(24))*exp(y(23))-(exp(y(23))*(exp(y(24))+exp(y(23)))-exp(y(23))*exp(y(23)))*T(243))/(T(114)*T(114));
T(245) = (T(114)*(-(exp(y(24))*exp(y(23))))-(-(exp(y(24))*exp(y(23))))*T(243))/(T(114)*T(114));
T(246) = (T(114)*(-(exp(y(24))*exp(y(23))))-(-(exp(y(24))*exp(y(23))))*(exp(y(23))*(exp(y(24))+exp(y(23)))+exp(y(23))*(exp(y(24))+exp(y(23)))))/(T(114)*T(114));
T(247) = (T(114)*(exp(y(24))*(exp(y(24))+exp(y(23)))+exp(y(24))*exp(y(24))-(exp(y(24))*exp(y(24))+exp(y(24))*exp(y(24))))-(exp(y(24))*(exp(y(24))+exp(y(23)))-exp(y(24))*exp(y(24)))*T(243))/(T(114)*T(114));
T(248) = (T(118)*(T(29)*(exp(y(26))+T(29))+T(29)*T(29)-(T(29)*T(29)+T(29)*T(29)))-(T(29)*(exp(y(26))+T(29))-T(29)*T(29))*(T(29)*(exp(y(26))+T(29))+T(29)*(exp(y(26))+T(29))))/(T(118)*T(118));
T(249) = exp(y(26))*(exp(y(26))+T(29))+exp(y(26))*(exp(y(26))+T(29));
T(250) = (T(118)*exp(y(26))*T(29)-(T(29)*(exp(y(26))+T(29))-T(29)*T(29))*T(249))/(T(118)*T(118));
T(251) = (T(118)*(-(exp(y(26))*T(29)))-(-(exp(y(26))*T(29)))*T(249))/(T(118)*T(118));
T(252) = (T(118)*(-(exp(y(26))*T(29)))-(-(exp(y(26))*T(29)))*(T(29)*(exp(y(26))+T(29))+T(29)*(exp(y(26))+T(29))))/(T(118)*T(118));
T(253) = (T(118)*(exp(y(26))*(exp(y(26))+T(29))+exp(y(26))*exp(y(26))-(exp(y(26))*exp(y(26))+exp(y(26))*exp(y(26))))-(exp(y(26))*(exp(y(26))+T(29))-exp(y(26))*exp(y(26)))*T(249))/(T(118)*T(118));
T(254) = T(41)+T(49)+params(21)*y(102)*exp(y(28))*params(6)*params(5)*params(5)*exp(params(5)*y(32));
T(255) = getPowerDeriv(T(9),T(10),3);
T(256) = T(151)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(257) = T(5)*T(256);
T(258) = T(143)+T(142)+exp(y(37))*(T(141)+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),T(11),3));
T(259) = y(58)*(-(T(82)*T(19)*T(16)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(143)+T(5)*T(19)*T(84)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(143)))+y(57)*(-(T(86)*T(3)*T(16)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(143)+T(17)*T(3)*T(84)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(143)));
T(260) = y(58)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(143)))+y(57)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(143)));
T(261) = T(154)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(262) = y(58)*(-(T(5)*(T(16)*T(53)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(154)+T(19)*T(53)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(83)*T(152))))+y(57)*(-(T(17)*(T(16)*T(53)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(151)+T(3)*T(53)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(83)*T(152))));
T(263) = y(58)*(-(T(82)*T(19)*T(54)*T(84)+T(19)*T(16)*T(54)*T(189)+T(82)*T(19)*T(54)*T(84)+T(5)*T(19)*T(54)*T(190)))+y(57)*(-(T(86)*T(3)*T(55)*T(84)+T(17)*T(3)*T(55)*T(190)+T(86)*T(3)*T(55)*T(84)+T(3)*T(16)*T(55)*T(194)));
T(264) = y(58)*(-(T(82)*T(19)*T(16)*T(53)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))+T(5)*T(19)*T(84)*T(53)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))))+y(57)*(-(T(17)*T(3)*T(84)*T(53)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))+T(86)*T(3)*T(16)*T(53)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))));
T(265) = y(58)*(-(T(5)*T(19)*T(16)*T(53)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))))+y(57)*(-(T(17)*T(3)*T(16)*T(53)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(266) = getPowerDeriv(T(64),T(10),3);
T(267) = T(148)+exp(y(91))*exp(y(91))*getPowerDeriv(exp(y(91)),T(11),2);
T(268) = (1-params(11))*(1-params(3))*exp(T(1)*y(96))*T(267);
T(269) = T(167)+T(166)+T(20)*(T(165)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(270) = getPowerDeriv(T(60),T(1),3);
T(271) = getPowerDeriv(T(60),T(13),3);
T(272) = T(57)*T(167)*T(57)*T(58)*T(170)+T(70)*T(57)*T(269)+T(57)*T(167)*T(57)*T(58)*T(170)+T(57)*T(58)*(T(57)*T(167)*T(170)+T(57)*T(58)*T(57)*T(58)*T(271));
T(273) = T(57)*T(167)*T(170)*T(59)*T(206)+T(70)*T(167)*T(206)+T(57)*T(58)*T(170)*T(58)*T(206)+T(57)*T(58)*(T(170)*T(58)*T(206)+T(57)*T(58)*T(59)*T(206)*T(271));
T(274) = T(206)+exp(y(92))*exp(y(92))*getPowerDeriv(exp(y(92)),1-params(3),2);
T(275) = T(58)*T(206)*T(170)*T(59)*T(206)+T(70)*T(58)*T(274)+T(58)*T(206)*T(170)*T(59)*T(206)+T(57)*T(58)*(T(59)*T(206)*T(59)*T(206)*T(271)+T(170)*T(59)*T(274));
T(276) = getPowerDeriv(T(6),T(13),3);
T(277) = T(82)*T(151)*T(152)*T(157)+T(83)*T(82)*T(256)+T(82)*T(151)*T(152)*T(157)+T(3)*T(82)*(T(157)*T(257)+T(152)*T(152)*T(276));
T(278) = getPowerDeriv(T(6),T(1),3);
T(279) = getPowerDeriv(T(25),(-params(14)),2);
T(280) = T(177)*(-(params(9)*(T(175)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(176)*T(176)*T(279);
T(281) = T(26)*exp(y(15))*T(177)+T(26)*exp(y(15))*T(177);
T(282) = getPowerDeriv(T(23),(-params(14)),3);
T(283) = T(184)*T(77)*T(185)+T(78)*(-(params(9)*(T(183)+T(182)+T(4)*(T(181)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(184)*T(77)*T(185)+T(77)*(T(184)*T(185)+T(77)*T(77)*T(282));
T(284) = T(189)+T(188)+T(4)*(T(187)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(285) = T(3)*T(189)*T(3)*T(82)*T(157)+T(83)*T(3)*T(284)+T(3)*T(189)*T(3)*T(82)*T(157)+T(3)*T(82)*(T(157)*T(3)*T(189)+T(3)*T(82)*T(3)*T(82)*T(276));
T(286) = getPowerDeriv(T(90),(-params(14)),2);
T(287) = params(1)*(T(212)*(-(params(9)*(T(210)+exp(y(92))*exp(y(92))*getPowerDeriv(exp(y(92)),1+params(8),2))/(1+params(8))))+T(211)*T(211)*T(286));
T(288) = y(58)*(-(T(82)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))+T(5)*T(19)*T(84)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))));
T(289) = y(57)*(-(T(86)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))+T(17)*T(3)*T(84)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(290) = T(219)+exp(y(40))*exp(y(40))*T(185)+exp(y(40))*(exp(y(40))*T(185)+exp(y(40))*exp(y(40))*T(282));
T(291) = getPowerDeriv(exp(y(52)-y(45)),params(5)-1,3);

end
